@echo off
:: ======================================================
:: Windows Update Auto Uninstaller (Multi-reboot sequence)
:: ======================================================
:: This script will automatically create:
::   step1.bat → step2.bat → step3.bat
:: And uninstall:
::   KB5066835 → Reboot → KB5066131 → Reboot → KB5065789
:: ======================================================

setlocal enabledelayedexpansion
set BASEDIR=C:\UninstallKB

:: Check administrator privilege
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo.
    echo [!] Please run this script as Administrator!
    pause
    exit /b
)

echo.
echo [*] Creating folder: %BASEDIR%
if not exist "%BASEDIR%" mkdir "%BASEDIR%"

echo [*] Generating step1.bat, step2.bat, and step3.bat ...

:: -------------------------------
:: step1.bat
:: -------------------------------
(
echo @echo off
echo :: Step 1 - Uninstall KB5066835
echo net session ^>nul 2^>^&1
echo if %%errorlevel%% neq 0 ^(
echo     echo Please run this file as Administrator!
echo     pause
echo     exit /b
echo ^)
echo echo.
echo echo Uninstalling KB5066835...
echo wusa /uninstall /kb:5066835 /quiet /norestart
echo echo.
echo echo Setting RunOnce to execute step2.bat after reboot...
echo reg add "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce" /v ContinueUninstall /t REG_SZ /d "%BASEDIR%\step2.bat" /f
echo echo.
echo echo Rebooting in 10 seconds...
echo timeout /t 10 /nobreak ^>nul
echo shutdown /r /t 0
) > "%BASEDIR%\step1.bat"

:: -------------------------------
:: step2.bat
:: -------------------------------
(
echo @echo off
echo :: Step 2 - Uninstall KB5066131
echo net session ^>nul 2^>^&1
echo if %%errorlevel%% neq 0 ^(
echo     echo Please run this file as Administrator!
echo     pause
echo     exit /b
echo ^)
echo echo.
echo echo Uninstalling KB5066131...
echo wusa /uninstall /kb:5066131 /quiet /norestart
echo echo.
echo echo Setting RunOnce to execute step3.bat after reboot...
echo reg add "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce" /v ContinueUninstall /t REG_SZ /d "%BASEDIR%\step3.bat" /f
echo echo.
echo echo Rebooting in 10 seconds...
echo timeout /t 10 /nobreak ^>nul
echo shutdown /r /t 0
) > "%BASEDIR%\step2.bat"

:: -------------------------------
:: step3.bat
:: -------------------------------
(
echo @echo off
echo :: Step 3 - Uninstall KB5065789
echo net session ^>nul 2^>^&1
echo if %%errorlevel%% neq 0 ^(
echo     echo Please run this file as Administrator!
echo     pause
echo     exit /b
echo ^)
echo echo.
echo echo Uninstalling KB5065789...
echo wusa /uninstall /kb:5065789 /quiet /norestart
echo echo.
echo echo Cleaning up RunOnce entry...
echo reg delete "HKLM\Software\Microsoft\Windows\CurrentVersion\RunOnce" /v ContinueUninstall /f ^>nul 2^>^&1
echo echo.
echo echo All specified KB updates have been successfully uninstalled!
echo pause
) > "%BASEDIR%\step3.bat"

echo.
echo [*] All batch files have been generated successfully!
echo [*] Starting Step 1 (KB5066835 removal)...
echo.
pause

cd /d "%BASEDIR%"
call step1.bat
